<?php

namespace App\Http\Livewire\Forms\Register;

use Illuminate\Validation\Rules\Password;

class StepTwoForm
{

    public static function rules() {
        return [
            'password' => ['required', 'confirmed', Password::min(8)->symbols()->numbers()->mixedCase()->letters()],
            'email' => 'required|email|max:255|unique:users',
            'phone_number' => 'required|string|unique:users',
            'username' => 'required|string|max:255|regex:/^\S*$/|alpha_num|unique:users'
        ];
    }
}
