<?php

namespace App\Http\Livewire\Auth;


use App\Models\User;
use Livewire\Component;

class Login extends Component
{
    public $username, $password, $remember;

    public function render() {
        return view('livewire.auth.login');
    }

    protected $rules = [
        'username' => 'required',
        'password' => 'required',
    ];

    public function login() {
        $this->validate();

        $credentials = [
            'username' => $this->username,
            'password' => $this->password,
        ];

        $login = auth()->attempt($credentials, $this->remember);

        if($login) {
            $user = User::find(auth()->id());
            
            session()->flash('message', 'Redirecting...');
            
            return to_route('dashboard');
            
        }
        session()->flash('error', 'Invalid Credentials.');
    }
}   
