<?php

namespace App\Http\Livewire\Admin;

use App\Models\User;
use Illuminate\Support\Facades\Artisan;
use Livewire\Component;

class GenerateTransaction extends Component
{
    public $currency;
    public $transaction_number;
    public $transaction_type;
    public $username;

    public function render()
    {
        return view('livewire.admin.generate-transaction')
            ->extends('includes.adminlayout');
    }
    protected $rules = [
        'transaction_number' => 'required|numeric|min:1',
        'username' => 'required|max:255',
        'transaction_type' => 'required|max:255',
    ];
    public function updated($property)
    {
        $this->validateOnly($property);
    }
    public function generateTransaction()
    {
        $this->validate();
        $user = User::firstWhere('username', $this->username);
        if ($user == null) {
            $this->addError('username', 'User with this username does not exist.');
        } else {
            session()->put([
                'generatee' => $this->username,
                'gen_number' => $this->transaction_number,
            ]);
            switch ($this->transaction_type) {
              case '1':
                for ($number=0; $number < $this->transaction_number ; $number++) { 
                  Artisan::call('db:seed', ['--force' => true, '--class'=>'LocalTransactionSeeder']);
                }
                break;
              case '2':
                for ($number=0; $number < $this->transaction_number ; $number++) { 
                  Artisan::call('db:seed', ['--force' => true, '--class'=>'InternationalTransactionSeeder']);
                }
                break;
              default:
                $this->addError('transaction_type', 'Please, select a valid transaction type.');
                break;
            }
            session()->forget(['generatee', 'gen_currency', 'gen_number']);

            $this->emit('generated', $this->transaction_number);
            $this->reset();
        }
    }
}
