<?php

namespace App\Http\Controllers\Pages;

use App\Http\Controllers\Controller;
use App\Models\Contact;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class ContactController extends Controller
{
    public function send(Request $request) {
        $validation = Validator::make($request->all(), [
            'name' => 'required|max:255',
            'email' => 'required|email|max:255',
            'subject' => 'required|max:255',
            'message' => 'required|max:255',
        ]);

        if($validation->fails()) {
            return $this->errorResponse($validation->errors()->all());
        }
        $contact = $request->except('_token');
        Contact::create($contact);

        return $this->successResponse('Your message has been sent successfully. We\'ll get back to you shortly.');
    }
}
