<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use App\Models\Admin;
use App\Models\User;
use App\Notifications\User\UserNotice;
use Illuminate\Http\Request;

class TicketController extends Controller
{
    public function index() {
        return view('dashboard.ticket');
    }

    public function save(Request $request) {
        $request->validate([
            'subject' => 'required|string|max:255',
            'message' => 'required|string',
        ]);

        $user = User::find(auth()->id());

        $user->contacts()->create([
            'name' => $user->name,
            'subject' => $request->subject,
            'message' => $request->message,
        ]);
        
        $user->notify(new UserNotice(
            subject:'Message Submitted', 
            message:'We have received your ticket. We will contact your shortly with this email address.'
        ));

        $admin = Admin::first();
        
        $admin->notify(new UserNotice(
            subject: 'New Message Request', 
            message: "$user->name sent a message, please, login to admin to review this.",
            action: [
                'text' => 'Login',
                'url' => route('admin.login'),
            ]
        ));

        return back()->with('success', $this->message('Message submitted.', 'We will get back to you shortly'));
    }
}
