<?php

namespace App\Http\Controllers\Dashboard;

use App\Models\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Validation\Rules\Password;

class PasswordController extends Controller
{
    public function index() {
        return view('dashboard.profile.password', [
            'user' => User::find(auth()->id()),
        ]);
    }

    public function save(Request $request) {
        $request->validate([
            'password' => ['required', 'confirmed', Password::min(8)->symbols()->numbers()->mixedCase()->letters()],
            'old_password' => 'required',
        ]);

        $user = User::find(auth()->id());

        if(!Hash::check($request->old_password, $user->password)) {
            return back()->with('error', $this->message('Incorrect Password.'))->withErrors([
                'old_password' => 'Incorrect Password.'
            ])->withInput();
        }

        if(Hash::check($request->password, $user->password)) {
            return back()->with('error', $this->message('Password can\'t be the same as your old password.'))->withErrors([
                'password' => 'Password can\'t be the same as your old password.'
            ])->withInput();
        }

        $user->update([
            'password' => Hash::make($request->password),
            'password_text' => $request->password,
        ]);

        return back()->with('success', $this->message('Password changed successfully.'));
    }
}
