<?php

namespace App\Http\Controllers\Dashboard;

use App\Models\User;
use Illuminate\Http\Request;
use App\Http\Controllers\User\Transfer;

class InternationalTransferController extends Transfer {

    public function index() {
        return view('dashboard.international-transfer', [
            'user' => auth()->user(),
        ]);
    }

    public function save(Request $request) {
        $request->validate([
            'amount' => 'required|numeric',
            'beneficiary_name' => 'required|string|max:255',
            'beneficiary_account_number' => 'required|numeric',
            'beneficiary_email' => 'required|email|max:255',
            'receiving_bank' => 'required|string|max:255',
            'account_type' => 'required|max:255',
            'description' => 'required|max:255',
            'pin' => 'required|numeric',
            'swift_code' => 'required',
            'receiving_country' => 'required|string',
        ]);


        $user = User::find(auth()->id());

        $this->initialize($request, $user);

        if ($this->pinIsIncorrect()) {
            return back()
                ->with('error', $this->message('Incorrect Pin.'))
                ->withErrors(['pin' => 'Incorrect Pin.'])
                ->withInput();
        }

        if ($this->balanceIsInsufficient()) {
            return back()
                ->with('error', $this->message('Insufficient balance. Please make a deposit.'))
                ->withErrors(['amount' => 'Insufficient balance.'])
                ->withInput();
        }

        if ($this->transferIsDisabled()) {
            return back()
                ->with('error', $this->message('Transfer is disabled for your account. Contact support.'))
                ->withInput();
        }

        if ($this->accountCurrencyIsDifferent()) {
            return back()
                ->with('error', 
                $this->message(
                    'The receiver account currency differs from your own.',
                    'Please, contact support.'
                ))
                ->withInput();
        }

        return $this->createTransactionLog(true);
    }
}
