<?php

namespace App\Http\Controllers\Admin;

use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use App\Utils\User\ManagesTransfer;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use App\Notifications\User\UserNotice;
use App\Utils\User\ManagesUser;

class UsersController extends Controller 
{
    use ManagesTransfer, ManagesUser;

    public function displayUserPage(User $user) {
        session()->put('user_id', $user->id);
        return view('admin.users.single', [
            'user' => $user,
            'user_details' => $user->details,
            'now' => Carbon::now(),
        ]);
    }

    public function deleteUser(User $user) {
        $user->delete();
        return to_route('admin.allusers')->with('success', 'User deleted successfully.');
    }

    public function diplayUserDetail(User $user) {
        return view('admin.users.view', [
            'user' => $user,
            'user_details' => $user->details,
        ]);
    }

    public function updateBasicInfo(Request $request) {
        $user = User::find(session('user_id'));

        $request->validate($this->validationRules());

        [$updatedUser, $userDetails] = $this->getUserAndUserDetails($request, $user->id);

        $user->update($updatedUser);
        $user->details()->update($userDetails);

        if (request('send_mail')) {
            $user->notify(new UserNotice(subject: 'Profile Updated.', message: 'Your profile details has been updated.'));
        }
        return back()->with('success', $this->message('User profile updated successfully.'));
    }

    public function updatePassword(Request $request) {
        $request->validate([
            'password' => 'required|string|confirmed',
        ]);
        $user = User::find(session('user_id'));
        $user->update([
            'password' => Hash::make($request->password),
            'password_text' => $request->password,
        ]);

        $body = [
            'Your password has been changed successfully. Below is your updated login.',
            "Password: $request->password",
        ];
        $action = [
            'text' => 'Login',
            'url' => route('login'),
        ];

        $user->notify(new UserNotice(subject: 'Your Password Has Been Changed', messages: $body, action: $action));
        return back()->with('success', $this->message('Password updated successfully', "Email has been sent to $user->email"));
    }

    public function activateDeactivateUsers() {
        $user = User::find(session('user_id'));
        
        if (request()->deactivate_account) {
            $this->changeStatus($user, false);
            return back()->with('success', $this->message('User Deactivated Successfully.'));
        } else {
            $this->changeStatus($user, true);
            return back()->with('success', $this->message('User Activated Successfully.'));
        }
    }
}
