<?php

namespace App\Http\Controllers\Admin;

use App\Models\User;
use Illuminate\Http\Request;
use App\Utils\User\ManagesUser;
use App\Notifications\User\Welcome;
use App\Http\Controllers\Controller;

class NewUserController extends Controller {
    use ManagesUser;

    public function save(Request $request) {
        $request->validate([
            'name' => 'required|min:2|max:255',
            'phone_number' => ['required', 'string', 'unique:users'],
            'email' => 'required|unique:users,email',
            'username' => ['required', 'string', 'max:255', 'regex:/^\S*$/', 'alpha_num', 'unique:users'],
            'pin' => 'required|numeric',
            'country' => 'required|string',
            'address' => 'required|string',
            'date_of_birth' => ['required', 'date'],
            'account_type' => 'required|string|max:255',
            'marital_status' => 'required|string|max:255',
            'occupation' => 'required|string',
            'currency' => 'required',
            'ssn' => 'required',
            'gender' => 'required',
            'password' => 'required|confirmed',
            'avatar' => 'nullable|image|max:4096'
        ],);

        [$user, $userDetails] = $this->getUserAndUserDetails($request, null);

        $user = User::create($user);
        $user->details()->create($userDetails);

        $this->storeAvatar($request, $user);

        $request->send_email ? $user->notify(new Welcome($user)): '';
        
        $request->verify_email ? $user->markEmailAsVerified() : $user->sendEmailVerificationNotification();

        return back()->with('success', $this->message('User created successfully.'));
    }

    private function storeAvatar(Request $request, User $user) {
        if($request->has('avatar')) {
            $file = $request->file('avatar');
            $avatarPath = '/uploads/'.$file->store('avatars', 'storage');
            
            $user->details()->update([
            'avatar' => $avatarPath,
        ]);
        }
    }
    
}
