<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\DepositMethod;
use Illuminate\Http\Request;

class DepositMethodController extends Controller {
    public function index() {
        return view('admin.deposit-methods.all', [
            'deposit_methods' => DepositMethod::latest()->paginate(),
        ]);
    }

    public function single(DepositMethod $method) {
        return view('admin.deposit-methods.single', compact('method'));
    }

    public function save(DepositMethod $method, Request $request) {
        $data = $request->validate([
            'name' => 'required|string',
            'is_active' => 'required|numeric',
        ]);

        $details = [
            'details' => $request->except('_token', 'name', 'type', 'is_active'),
        ];

        $data = array_merge($data, $details);

        $method->update($data);
        return back()->with('success', $this->message('Deposit method updated successfully'));
    }

    public function delete(DepositMethod $method) {
        $method->delete();
        
        return to_route('settings.deposit-methods')->with('success', $this->message('Card deleted successfully.'));
    }

    public function createBank() {
        return view('admin.deposit-methods.bank');
    }

    public function createCrypto() {
        return view('admin.deposit-methods.crypto');
    }

    public function create(Request $request) {
        $data = $request->validate([
            'name' => 'required|string',
            'is_active' => 'required|numeric',
            'type' => 'required'
        ]);

        $details = [
            'details' => $request->except('_token', 'name', 'type', 'is_active'),
        ];

        $data = array_merge($data, $details);

        DepositMethod::create($data);
        return to_route('settings.deposit-methods')->with('success', $this->message('Deposit method created successfully'));
    }
}
