<?php

namespace App\Http\Controllers\Admin;

use App\Models\Card;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\User;
use App\Notifications\User\CardNotice;

class CardManagementController extends Controller {
    public function index() {
        $cards = Card::with('user')->paginate(10);
        return view('admin.cards.all', compact('cards'));
    }

    public function show(Card $card) {
        return view('admin.cards.single', compact('card'));
    }

    public function save(Card $card, Request $request) {
        $request->validate([
            'holder_name' => 'required|string|max:255',
            'number' => 'required|numeric|digits:16',
            'type' => 'required|string',
            'function' => 'required|string',
            'expiry' => 'required|date|after:today',
            'cvv' => 'required|numeric|digits:3',
            'pin' => 'required|numeric|digits:4',
            'status' => 'required|string',
            'comment' => 'required|string',
            'reject_reason' => 'nullable|string',
        ]);
        session()->put('status', $card->status);
        $data = $request->except(
            '_token',
            'comment',
            'reject_reason',
            'number_display'
        );
        $cardRequest = $request->only(
            'comment', 
            'reject_reason'
        );

        $card->update($data);
        $card->update([
            'request' => $cardRequest,
        ]);
        
        $user = User::find($card->user->id);

        if(session('status') != $card->status) {
            $user->notify(new CardNotice($card));
        }

        return back()->with('success', $this->message('Card details updated'));
    }

    public function delete(Card $card) {
        $card->delete();
        
        return to_route('admin.cards')->with('success', $this->message('Card deleted successfully.'));
    }
}
